using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents VistALink fault message as defined 
	/// in vlFault.xsd (VistALink protocol specification).
	/// </summary>
	public sealed class VistALinkFaultMessage : BaseFaultMessage
	{
		/// <summary>
		/// VistALink message type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string MessageType = "gov.va.med.foundations.vistalink.system.fault";

		/// <summary>
		/// VistALink message XSD schema file name string. 		
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string XsdName = "vlFault.xsd";

		/// <summary>
		/// Constructor specifying minimal required VistALink system fault message parameters. 
		/// </summary>
		/// <param name="faultInfo">Fault info object containing information about the fault.</param>
		public VistALinkFaultMessage( FaultInfo faultInfo ) 
			: base( MessageType, XsdName, faultInfo ) {}

		/// <summary>
		/// Standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceDoc">Source XML document</param>
		public VistALinkFaultMessage( XmlDocument sourceDoc )
			: base( MessageType, XsdName, sourceDoc ) {}
	}
}
